#pragma once


namespace SlikServerC {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace NDISLIKDA;

	/// <summary>
	/// Summary for Form1
	///
	/// WARNING: If you change the name of this class, you will need to change the
	///          'Resource File Name' property for the managed resource compiler tool
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public ref class Form1 : public System::Windows::Forms::Form
	{
	public:
		Form1(void)
		{
			InitializeComponent();
			//
			//TODO: Add the constructor code here
			//
		}
#pragma region Windows Form Designer generated code
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}

	internal: System::Windows::Forms::CheckBox^  SimulationEnabled;
	private: 
	internal: System::Windows::Forms::Label^  Label4;
	internal: System::Windows::Forms::NumericUpDown^  NumericUpDown1;
	internal: System::Windows::Forms::Label^  Label3;
	internal: System::Windows::Forms::CheckBox^  SimulationCheckbox;
	internal: System::Windows::Forms::Label^  Label6;
	internal: System::Windows::Forms::Label^  Label5;
	internal: System::Windows::Forms::GroupBox^  GroupBox3;
	internal: System::Windows::Forms::Label^  Label7;
	internal: System::Windows::Forms::NumericUpDown^  SimulationNumeric;
	internal: System::Windows::Forms::ProgressBar^  SimulationProgressBar;
	internal: System::Windows::Forms::TextBox^  UserTextBox;
	internal: System::Windows::Forms::Label^  UserNumericLabel;
	internal: System::Windows::Forms::NumericUpDown^  UserNumeric;
	internal: System::Windows::Forms::CheckBox^  UserCheckBox;
	internal: System::Windows::Forms::GroupBox^  GroupBox2;

	internal: System::Windows::Forms::Label^  Label1;
	internal: System::Windows::Forms::Button^  ExitButton;
	internal: System::Windows::Forms::LinkLabel^  LinkLabel1;
	internal: System::Windows::Forms::Label^  Label8;
	private: System::Windows::Forms::Timer^  timer1;
	private: System::Windows::Forms::Label^  ConnectedClients;
	private: AxNDISLIKDA::AxSLIKServer^  SlikServer1;


	private: AxNDISLIKDA::AxSLIKServer^  SLIKServer1;
	internal: 
	private: System::ComponentModel::IContainer^  components;
	protected: 

	protected: 

	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->components = (gcnew System::ComponentModel::Container());
			System::ComponentModel::ComponentResourceManager^  resources = (gcnew System::ComponentModel::ComponentResourceManager(Form1::typeid));
			this->SimulationEnabled = (gcnew System::Windows::Forms::CheckBox());
			this->Label4 = (gcnew System::Windows::Forms::Label());
			this->NumericUpDown1 = (gcnew System::Windows::Forms::NumericUpDown());
			this->Label3 = (gcnew System::Windows::Forms::Label());
			this->SimulationCheckbox = (gcnew System::Windows::Forms::CheckBox());
			this->Label6 = (gcnew System::Windows::Forms::Label());
			this->Label5 = (gcnew System::Windows::Forms::Label());
			this->GroupBox3 = (gcnew System::Windows::Forms::GroupBox());
			this->Label7 = (gcnew System::Windows::Forms::Label());
			this->SimulationNumeric = (gcnew System::Windows::Forms::NumericUpDown());
			this->SimulationProgressBar = (gcnew System::Windows::Forms::ProgressBar());
			this->UserTextBox = (gcnew System::Windows::Forms::TextBox());
			this->UserNumericLabel = (gcnew System::Windows::Forms::Label());
			this->UserNumeric = (gcnew System::Windows::Forms::NumericUpDown());
			this->UserCheckBox = (gcnew System::Windows::Forms::CheckBox());
			this->GroupBox2 = (gcnew System::Windows::Forms::GroupBox());
			this->Label1 = (gcnew System::Windows::Forms::Label());
			this->ExitButton = (gcnew System::Windows::Forms::Button());
			this->LinkLabel1 = (gcnew System::Windows::Forms::LinkLabel());
			this->Label8 = (gcnew System::Windows::Forms::Label());
			this->timer1 = (gcnew System::Windows::Forms::Timer(this->components));
			this->ConnectedClients = (gcnew System::Windows::Forms::Label());
			this->SlikServer1 = (gcnew AxNDISLIKDA::AxSLIKServer());
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->NumericUpDown1))->BeginInit();
			this->GroupBox3->SuspendLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->SimulationNumeric))->BeginInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->UserNumeric))->BeginInit();
			this->GroupBox2->SuspendLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->SlikServer1))->BeginInit();
			this->SuspendLayout();
			// 
			// SimulationEnabled
			// 
			this->SimulationEnabled->AutoSize = true;
			this->SimulationEnabled->Location = System::Drawing::Point(15, 222);
			this->SimulationEnabled->Name = L"SimulationEnabled";
			this->SimulationEnabled->Size = System::Drawing::Size(65, 17);
			this->SimulationEnabled->TabIndex = 8;
			this->SimulationEnabled->Text = L"Enabled";
			this->SimulationEnabled->UseVisualStyleBackColor = true;
			this->SimulationEnabled->CheckedChanged += gcnew System::EventHandler(this, &Form1::SimulationEnabled_CheckedChanged);
			// 
			// Label4
			// 
			this->Label4->AutoSize = true;
			this->Label4->Location = System::Drawing::Point(12, 124);
			this->Label4->Name = L"Label4";
			this->Label4->Size = System::Drawing::Size(68, 13);
			this->Label4->TabIndex = 4;
			this->Label4->Text = L"UserTextBox";
			// 
			// NumericUpDown1
			// 
			this->NumericUpDown1->Increment = System::Decimal(gcnew cli::array< System::Int32 >(4) {100, 0, 0, 0});
			this->NumericUpDown1->Location = System::Drawing::Point(86, 221);
			this->NumericUpDown1->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) {5000, 0, 0, 0});
			this->NumericUpDown1->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) {100, 0, 0, 0});
			this->NumericUpDown1->Name = L"NumericUpDown1";
			this->NumericUpDown1->Size = System::Drawing::Size(66, 20);
			this->NumericUpDown1->TabIndex = 6;
			this->NumericUpDown1->Value = System::Decimal(gcnew cli::array< System::Int32 >(4) {500, 0, 0, 0});
			this->NumericUpDown1->ValueChanged += gcnew System::EventHandler(this, &Form1::NumericUpDown1_ValueChanged);
			// 
			// Label3
			// 
			this->Label3->AutoSize = true;
			this->Label3->Location = System::Drawing::Point(12, 203);
			this->Label3->Name = L"Label3";
			this->Label3->Size = System::Drawing::Size(177, 13);
			this->Label3->TabIndex = 5;
			this->Label3->Text = L"Simulation Data Change Frequency:";
			// 
			// SimulationCheckbox
			// 
			this->SimulationCheckbox->AutoSize = true;
			this->SimulationCheckbox->CheckAlign = System::Drawing::ContentAlignment::MiddleRight;
			this->SimulationCheckbox->Location = System::Drawing::Point(15, 140);
			this->SimulationCheckbox->Name = L"SimulationCheckbox";
			this->SimulationCheckbox->Size = System::Drawing::Size(122, 17);
			this->SimulationCheckbox->TabIndex = 4;
			this->SimulationCheckbox->Text = L"SimulationCheckbox";
			this->SimulationCheckbox->UseVisualStyleBackColor = true;
			this->SimulationCheckbox->CheckedChanged += gcnew System::EventHandler(this, &Form1::SimulationCheckbox_CheckedChanged);
			// 
			// Label6
			// 
			this->Label6->AutoSize = true;
			this->Label6->Location = System::Drawing::Point(12, 85);
			this->Label6->Name = L"Label6";
			this->Label6->Size = System::Drawing::Size(94, 13);
			this->Label6->TabIndex = 3;
			this->Label6->Text = L"SimulationNumeric";
			// 
			// Label5
			// 
			this->Label5->AutoSize = true;
			this->Label5->Location = System::Drawing::Point(12, 39);
			this->Label5->Name = L"Label5";
			this->Label5->Size = System::Drawing::Size(112, 13);
			this->Label5->TabIndex = 1;
			this->Label5->Text = L"SimulationProgressBar";
			// 
			// GroupBox3
			// 
			this->GroupBox3->Controls->Add(this->SimulationEnabled);
			this->GroupBox3->Controls->Add(this->Label7);
			this->GroupBox3->Controls->Add(this->NumericUpDown1);
			this->GroupBox3->Controls->Add(this->Label3);
			this->GroupBox3->Controls->Add(this->SimulationCheckbox);
			this->GroupBox3->Controls->Add(this->Label6);
			this->GroupBox3->Controls->Add(this->SimulationNumeric);
			this->GroupBox3->Controls->Add(this->Label5);
			this->GroupBox3->Controls->Add(this->SimulationProgressBar);
			this->GroupBox3->Location = System::Drawing::Point(220, 83);
			this->GroupBox3->Name = L"GroupBox3";
			this->GroupBox3->Size = System::Drawing::Size(230, 257);
			this->GroupBox3->TabIndex = 3;
			this->GroupBox3->TabStop = false;
			this->GroupBox3->Text = L"Simulation Data";
			// 
			// Label7
			// 
			this->Label7->AutoSize = true;
			this->Label7->Location = System::Drawing::Point(157, 223);
			this->Label7->Name = L"Label7";
			this->Label7->Size = System::Drawing::Size(32, 13);
			this->Label7->TabIndex = 7;
			this->Label7->Text = L"msec";
			// 
			// SimulationNumeric
			// 
			this->SimulationNumeric->Location = System::Drawing::Point(15, 101);
			this->SimulationNumeric->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) {9999999, 0, 0, 0});
			this->SimulationNumeric->Name = L"SimulationNumeric";
			this->SimulationNumeric->Size = System::Drawing::Size(199, 20);
			this->SimulationNumeric->TabIndex = 2;
			this->SimulationNumeric->ValueChanged += gcnew System::EventHandler(this, &Form1::SimulationNumeric_ValueChanged);
			// 
			// SimulationProgressBar
			// 
			this->SimulationProgressBar->Location = System::Drawing::Point(15, 55);
			this->SimulationProgressBar->Name = L"SimulationProgressBar";
			this->SimulationProgressBar->Size = System::Drawing::Size(199, 18);
			this->SimulationProgressBar->TabIndex = 0;
			// 
			// UserTextBox
			// 
			this->UserTextBox->Location = System::Drawing::Point(15, 140);
			this->UserTextBox->Name = L"UserTextBox";
			this->UserTextBox->Size = System::Drawing::Size(164, 20);
			this->UserTextBox->TabIndex = 3;
			this->UserTextBox->TextChanged += gcnew System::EventHandler(this, &Form1::UserTextBox_TextChanged);
			// 
			// UserNumericLabel
			// 
			this->UserNumericLabel->AutoSize = true;
			this->UserNumericLabel->Location = System::Drawing::Point(12, 85);
			this->UserNumericLabel->Name = L"UserNumericLabel";
			this->UserNumericLabel->Size = System::Drawing::Size(68, 13);
			this->UserNumericLabel->TabIndex = 2;
			this->UserNumericLabel->Text = L"UserNumeric";
			// 
			// UserNumeric
			// 
			this->UserNumeric->Location = System::Drawing::Point(113, 83);
			this->UserNumeric->Name = L"UserNumeric";
			this->UserNumeric->Size = System::Drawing::Size(66, 20);
			this->UserNumeric->TabIndex = 1;
			this->UserNumeric->Value = System::Decimal(gcnew cli::array< System::Int32 >(4) {10, 0, 0, 0});
			this->UserNumeric->ValueChanged += gcnew System::EventHandler(this, &Form1::UserNumeric_ValueChanged);
			// 
			// UserCheckBox
			// 
			this->UserCheckBox->AutoSize = true;
			this->UserCheckBox->CheckAlign = System::Drawing::ContentAlignment::MiddleRight;
			this->UserCheckBox->Location = System::Drawing::Point(15, 39);
			this->UserCheckBox->Name = L"UserCheckBox";
			this->UserCheckBox->Size = System::Drawing::Size(96, 17);
			this->UserCheckBox->TabIndex = 0;
			this->UserCheckBox->Text = L"UserCheckbox";
			this->UserCheckBox->UseVisualStyleBackColor = true;
			this->UserCheckBox->CheckedChanged += gcnew System::EventHandler(this, &Form1::UserCheckBox_CheckedChanged);
			// 
			// GroupBox2
			// 
			this->GroupBox2->Controls->Add(this->Label4);
			this->GroupBox2->Controls->Add(this->UserTextBox);
			this->GroupBox2->Controls->Add(this->UserNumericLabel);
			this->GroupBox2->Controls->Add(this->UserNumeric);
			this->GroupBox2->Controls->Add(this->UserCheckBox);
			this->GroupBox2->Location = System::Drawing::Point(18, 83);
			this->GroupBox2->Name = L"GroupBox2";
			this->GroupBox2->Size = System::Drawing::Size(196, 257);
			this->GroupBox2->TabIndex = 2;
			this->GroupBox2->TabStop = false;
			this->GroupBox2->Text = L"User Entry";
			// 
			// Label1
			// 
			this->Label1->AutoSize = true;
			this->Label1->Location = System::Drawing::Point(79, 35);
			this->Label1->Name = L"Label1";
			this->Label1->Size = System::Drawing::Size(148, 13);
			this->Label1->TabIndex = 4;
			this->Label1->Text = L"Number of Connected Clients:";
			// 
			// ExitButton
			// 
			this->ExitButton->Anchor = static_cast<System::Windows::Forms::AnchorStyles>((System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Right));
			this->ExitButton->Location = System::Drawing::Point(375, 371);
			this->ExitButton->Name = L"ExitButton";
			this->ExitButton->Size = System::Drawing::Size(75, 23);
			this->ExitButton->TabIndex = 6;
			this->ExitButton->Text = L"Exit";
			this->ExitButton->UseVisualStyleBackColor = true;
			this->ExitButton->Click += gcnew System::EventHandler(this, &Form1::ExitButton_Click);
			// 
			// LinkLabel1
			// 
			this->LinkLabel1->AutoSize = true;
			this->LinkLabel1->Location = System::Drawing::Point(221, 376);
			this->LinkLabel1->Name = L"LinkLabel1";
			this->LinkLabel1->Size = System::Drawing::Size(125, 13);
			this->LinkLabel1->TabIndex = 8;
			this->LinkLabel1->TabStop = true;
			this->LinkLabel1->Text = L"http://www.nordyn.com/";
			// 
			// Label8
			// 
			this->Label8->AutoSize = true;
			this->Label8->Location = System::Drawing::Point(69, 376);
			this->Label8->Name = L"Label8";
			this->Label8->Size = System::Drawing::Size(145, 13);
			this->Label8->TabIndex = 7;
			this->Label8->Text = L"SLIK-DA OPC Server Toolkit:";
			// 
			// timer1
			// 
			this->timer1->Interval = 500;
			this->timer1->Tick += gcnew System::EventHandler(this, &Form1::timer1_Tick);
			// 
			// ConnectedClients
			// 
			this->ConnectedClients->AutoSize = true;
			this->ConnectedClients->Location = System::Drawing::Point(233, 35);
			this->ConnectedClients->Name = L"ConnectedClients";
			this->ConnectedClients->Size = System::Drawing::Size(13, 13);
			this->ConnectedClients->TabIndex = 9;
			this->ConnectedClients->Text = L"0";
			// 
			// SlikServer1
			// 
			this->SlikServer1->Enabled = true;
			this->SlikServer1->Location = System::Drawing::Point(13, 347);
			this->SlikServer1->Name = L"SlikServer1";
			this->SlikServer1->OcxState = (cli::safe_cast<System::Windows::Forms::AxHost::State^  >(resources->GetObject(L"SlikServer1.OcxState")));
			this->SlikServer1->Size = System::Drawing::Size(32, 32);
			this->SlikServer1->TabIndex = 0;
			this->SlikServer1->OnClientDisconnect += gcnew AxNDISLIKDA::_ISLIKServerEvents3_OnClientDisconnectEventHandler(this, &Form1::SlikServer1_OnClientDisconnect);
			this->SlikServer1->OnWrite += gcnew AxNDISLIKDA::_ISLIKServerEvents3_OnWriteEventHandler(this, &Form1::SlikServer1_OnWrite);
			this->SlikServer1->OnClientConnect += gcnew AxNDISLIKDA::_ISLIKServerEvents3_OnClientConnectEventHandler(this, &Form1::SlikServer1_OnClientConnect);
			this->SlikServer1->OnRead += gcnew AxNDISLIKDA::_ISLIKServerEvents3_OnReadEventHandler(this, &Form1::SlikServer1_OnRead);
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(464, 411);
			this->Controls->Add(this->SlikServer1);
			this->Controls->Add(this->ConnectedClients);
			this->Controls->Add(this->LinkLabel1);
			this->Controls->Add(this->Label8);
			this->Controls->Add(this->ExitButton);
			this->Controls->Add(this->Label1);
			this->Controls->Add(this->GroupBox3);
			this->Controls->Add(this->GroupBox2);
			this->Name = L"Form1";
			this->Text = L"C++ Simple Server";
			this->Load += gcnew System::EventHandler(this, &Form1::Form1_Load);
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->NumericUpDown1))->EndInit();
			this->GroupBox3->ResumeLayout(false);
			this->GroupBox3->PerformLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->SimulationNumeric))->EndInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->UserNumeric))->EndInit();
			this->GroupBox2->ResumeLayout(false);
			this->GroupBox2->PerformLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->SlikServer1))->EndInit();
			this->ResumeLayout(false);
			this->PerformLayout();

		}

	

#pragma endregion Windows Form Designer generated code

	//this variable will hold our tag-database
	private: ISLIKTags ^myOpcTags;
    //we will use a random number generator
	private: Random randomizer;

    //create delegates for use on the Events that need to update form controls
	public: delegate System::Void OnClientConnectCallback(System::Object^  sender, AxNDISLIKDA::_ISLIKServerEvents3_OnClientConnectEvent^  e);
    public: delegate System::Void OnClientDisconnectCallback(System::Object^  sender, AxNDISLIKDA::_ISLIKServerEvents3_OnClientDisconnectEvent^  e);
	public: delegate System::Void OnWriteCallback(System::Object^  sender, AxNDISLIKDA::_ISLIKServerEvents3_OnWriteEvent^  e);

#pragma region Windows Form Events

    //Run the Initialization code when the form loads
	private: System::Void Form1_Load(System::Object^  sender, System::EventArgs^  e) {

				 //create a new instance of an empty tag database
				 myOpcTags = SlikServer1->SLIKTags;

				 //define a simple read/write access-right
				 AccessPermissionsEnum readWriteAccess = AccessPermissionsEnum::sdaWriteAccess + AccessPermissionsEnum::sdaReadAccess;
	
				 //add the user-tags. These are the tags that represent the 3 form
				 //controls on the LEFT side of the form
				 myOpcTags->Add("User.CheckBox", (int)readWriteAccess, 0, 0, DateTime::Now, nullptr);
				 myOpcTags->Add("User.Numeric", (int)readWriteAccess, 0, 0, DateTime::Now, nullptr);
				 myOpcTags->Add("User.TextBox", (int)readWriteAccess, 0, 0, DateTime::Now, nullptr);
				 
				 //add the simulation tags. These are the tags that represent the 3
                 //form controls on the RIGHT side of the form
				 myOpcTags->Add("Simulation.ProgressBar", (int)readWriteAccess, 0, 0, DateTime::Now, nullptr);
				 myOpcTags->Add("Simulation.Numeric", (int)readWriteAccess, 0, 0, DateTime::Now, nullptr);
				 myOpcTags->Add("Simulation.CheckBox", (int)readWriteAccess, 0, 0, DateTime::Now, nullptr);
				
				 //setup the tag DATA TYPES of these tags. We could've done these above,
                 //but we've separated them here to illustrate the 2 tag groupings above.
				 myOpcTags->Item("User.CheckBox")->DataType = (short)Microsoft::VisualBasic::VariantType::Boolean;
				 myOpcTags->Item("User.Numeric")->DataType = (short)Microsoft::VisualBasic::VariantType::Integer;
				 myOpcTags->Item("User.TextBox")->DataType = (short)Microsoft::VisualBasic::VariantType::String;
                 myOpcTags->Item("Simulation.ProgressBar")->DataType =(short)Microsoft::VisualBasic::VariantType::Integer;
				 myOpcTags->Item("Simulation.Numeric")->DataType = (short)Microsoft::VisualBasic::VariantType::Integer;
				 myOpcTags->Item("Simulation.CheckBox")->DataType = (short)Microsoft::VisualBasic::VariantType::Boolean;

				 //In this example, we will also register and start the server
				 //Under normal circumstances you would NOT do this, because this is a
                 //step that should be done once and once-only, at the end of an
				 //installation routine. Most OPC Server implementations allow the use
				 //of a command-line argument to call this function.
				 SlikServer1->RegisterServer();
				 
				 //Now START the OPC Server interface. This is called whenever your application starts.
				 SlikServer1->StartServer();
			 }	

    //This code is executed when the EXIT button is clicked.
	private: System::Void ExitButton_Click(System::Object^  sender, System::EventArgs^  e) {

				 if(MessageBox::Show("Close the OPC Server and Exit?", "Exit?", MessageBoxButtons::YesNo, System::Windows::Forms::MessageBoxIcon::Question, System::Windows::Forms::MessageBoxDefaultButton::Button2) == Windows::Forms::DialogResult::Yes)
				 {
					try
					{
						//Notify the OPC Clients that you want to shut down. This gives
                        //each OPC Client enough time to gracefully disconnect.
						SlikServer1->RequestDisconnect("User Requested Shutdown");

						//This function, just like the ".RegisterServer" as seen in the 
						//Form_Load() event is a function that should not be called under
						//normal circumstances. This should be done by the installer
						//when the application is being removed from the computer.
						//SlikServer1->UnregisterServer();

					}
					catch(Exception ^ex)
					{
					}
					finally
					{
						Application::Exit();
					}
				 }

			 }

//When the (right-side) CHECKBOX changes, Start the Timer.
private: System::Void SimulationEnabled_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
			 timer1->Enabled = SimulationEnabled->Checked;
		 }

// Timer interval changer.
private: System::Void NumericUpDown1_ValueChanged(System::Object^  sender, System::EventArgs^  e) {
			 timer1->Interval = (int)NumericUpDown1->Value;
		 }

//When the Simulated NUMERIC changes, update the OPC Tag.
private: System::Void SimulationNumeric_ValueChanged(System::Object^  sender, System::EventArgs^  e) {
			 if(myOpcTags != nullptr)
				 myOpcTags->Item("Simulation.Numeric")->SetVQT(Convert::ToInt32(SimulationNumeric->Value), 192, DateTime::Now);
		 }

//When the simulated Checbox changes, update the OPC Tag.
private: System::Void SimulationCheckbox_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
			 if(myOpcTags != nullptr)
				 myOpcTags->Item("Simulation.CheckBox")->SetVQT(SimulationCheckbox->Checked, 192, DateTime::Now);
		 }

//When the USER checkbox changes, update the applicable OPC Tag
private: System::Void UserCheckBox_CheckedChanged(System::Object^  sender, System::EventArgs^  e) {
			 if(myOpcTags != nullptr)
				 myOpcTags->Item("User.CheckBox")->SetVQT(UserCheckBox->Checked, 192, DateTime::Now);
		 }

//When the USER Numeric control changes, update the applicable OPC Tag
private: System::Void UserNumeric_ValueChanged(System::Object^  sender, System::EventArgs^  e) {
			 if(myOpcTags != nullptr)
				 myOpcTags->Item("User.Numeric")->SetVQT(Convert::ToInt32(UserNumeric->Value), 192, DateTime::Now);
		 }
//When the USER Textbox value changes, update the applicable OPC Tag
private: System::Void UserTextBox_TextChanged(System::Object^  sender, System::EventArgs^  e) {
			 if(myOpcTags != nullptr)
				 myOpcTags->Item("User.TextBox")->SetVQT(UserTextBox->Text, 192, DateTime::Now);
		 }
//The timer generates random values that are then sent to the SIMULATED controls
private: System::Void timer1_Tick(System::Object^  sender, System::EventArgs^  e) {
			 SimulationProgressBar->Value = Convert::ToInt32(randomizer.Next(100));
			 SimulationNumeric->Value = Convert::ToDecimal(randomizer.Next(99999));
             SimulationCheckbox->Checked = Convert::ToBoolean(randomizer.Next(-1, 1));

			 myOpcTags->Item("Simulation.ProgressBar")->SetVQT(Convert::ToInt32(SimulationProgressBar->Value), 192, DateTime::Now);
		 }

#pragma endregion Windows Form Events

#pragma region SLIKDA Events

//Event raised whenever an OPC Client connects
private: System::Void SlikServer1_OnClientConnect(System::Object^  sender, AxNDISLIKDA::_ISLIKServerEvents3_OnClientConnectEvent^  e) {
			if(this->InvokeRequired)
			{
				this->BeginInvoke(gcnew OnClientConnectCallback(this, &Form1::SlikServer1_OnClientConnect), sender, e);
			}
			else
			{
				ConnectedClients->Text = e->numClients.ToString();
			}
			
		 }

//Event raised whenever an OPC Client DISCONNECTS
private: System::Void SlikServer1_OnClientDisconnect(System::Object^  sender, AxNDISLIKDA::_ISLIKServerEvents3_OnClientDisconnectEvent^  e) {
			 if(this->InvokeRequired)
			{
				this->BeginInvoke(gcnew OnClientDisconnectCallback(this, &Form1::SlikServer1_OnClientDisconnect), sender, e);
			}
			else
			{
				ConnectedClients->Text = e->numClients.ToString();
			}
		 }

//Event raised when an OPC client requests to WRITE some values to some Tags
//You are then responsible for 'making this happen', which could mean:
//  (a) you write the values to some PLC/DCS system, i.e. some kind of hardware
//  (b) you update the screen, as in this example
//  (c) you update some other software etc.
private: System::Void SlikServer1_OnWrite(System::Object^  sender, AxNDISLIKDA::_ISLIKServerEvents3_OnWriteEvent^  e) {
			 
			if(this->InvokeRequired)
			{
				this->BeginInvoke(gcnew OnWriteCallback(this, &Form1::SlikServer1_OnWrite), sender, e);
			}
			else
			{

				 //Iterate thru each/every item that the OPC Client has requested us to WRITE
				 for(int i = 0; i < e->count; i++)
				 {
					 //Get the "next" item in the list
					 ISLIKTag ^currentItem = e->tags[i];
					 Object ^currentValue = e->values[i];
					 String ^currentName = currentItem->Name;

					 //We will look at the name of the OPC Tag to then figure out WHERE
					 //to SEND the data to....

					 //Checkbox on the LEFT side of the form
					 if(currentItem->Name == "User.CheckBox")
							UserCheckBox->Checked = Convert::ToBoolean(currentValue);
					 //Numeric control on the LEFT side of the form
					 else if(currentItem->Name == "User.Numeric")
							UserNumeric->Value = Convert::ToInt32(currentValue);
					 //Textbox on the LEFT side of the form
					 else if(currentItem->Name == "User.TextBox")
							UserTextBox->Text = Convert::ToString(currentValue);
					 //Progress bar on the RIGHT side of the form
					 else if(currentItem->Name == "Simulation.ProgressBar")
							SimulationProgressBar->Value = Convert::ToInt32(currentValue);
					 //Numeric control on the RIGHT side of the form
					 else if(currentItem->Name == "Simulation.Numeric")	
							SimulationNumeric->Value = Convert::ToInt32(currentValue);
					 //Checkbox on the RIGHT side of the form
					 else if(currentItem->Name == "Simulation.CheckBox")	
							SimulationCheckbox->Checked = Convert::ToBoolean(currentValue);

					 //Specify that the Item at *this* position is NOT in error!
					 e->errors[i] = (int)OPCDAErrorsEnum::sdaSOK;
				 }
				 //Now specify that we completed this event successfully
				 e->result = (int)OPCDAErrorsEnum::sdaSOK;
			}
		 }

//Event raised when an OPC client requests to READ the values to some Tags
//You are then responsible for 'making this happen', which could mean:
//  (a) you READ the values from some PLC/DCS system, i.e. some kind of hardware
//  (b) you READ the values fom the screen, as in this example
//  (c) you READ the values from some other software etc.
private: System::Void SlikServer1_OnRead(System::Object^  sender, AxNDISLIKDA::_ISLIKServerEvents3_OnReadEvent^  e) {

			 //Iterate thru each/every item that the OPC Client has requested us to READ
			 for(int i = 0; i < e->count; i++)
			 {
				 //Get the "next" item in the list
				ISLIKTag ^currentItem = e->tags[i];

				//Now to return the value of this tag, along with
				//GOOD quality, and a current timestamp
				//(Quality codes are: 192=GOOD; 0=BAD)
            
				//We will look at the name of the OPC Tag to then figure out WHERE
				//to get the data from....

				//Checkbox on the LEFT side of the form
				if(currentItem->Name == "User.CheckBox")
					e->tags[i]->SetVQT(UserCheckBox->Checked, 192, DateTime::Now);
				//Numeric control on the LEFT side of the form
				else if(currentItem->Name == "User.Numeric")
					e->tags[i]->SetVQT(Convert::ToInt32(UserNumeric->Value), 192, DateTime::Now);
				//Textbox on the LEFT side of the form
				else if(currentItem->Name == "User.TextBox")
					e->tags[i]->SetVQT(UserTextBox->Text, 192, DateTime::Now);
				//Progress bar on the RIGHT side of the form
				else if(currentItem->Name == "Simulation.ProgressBar")
					e->tags[i]->SetVQT(SimulationProgressBar->Value, 192, DateTime::Now);
				//Numeric control on the RIGHT side of the form
				else if(currentItem->Name == "Simulation.Numeric")	
					 e->tags[i]->SetVQT(Convert::ToInt32(SimulationNumeric->Value), 192, DateTime::Now);
				//Checkbox on the RIGHT side of the form
				else if(currentItem->Name == "Simulation.CheckBox")	
					 e->tags[i]->SetVQT(SimulationCheckbox->Checked, 192, DateTime::Now);

				//Specify that the Item at *this* position is NOT in error!
				e->errors[i] = (int)OPCDAErrorsEnum::sdaSOK;
			 }
			
			//Now specify that we completed this event successfully
			e->result = (int)OPCDAErrorsEnum::sdaSOK;
		 }
};
#pragma endregion SLIKDA Events

	//MANY OTHER EVENTS DO EXIST, ADDING EVEN MORE POWER AND FUNCTIONALITY

}

